/*
 * Decompiled with CFR 0.152.
 */
package com.anatawa12.libs;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000\n\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u0016\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001\u001a\u0016\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001\u001a\f\u0010\u0006\u001a\u00020\u0001*\u00020\u0001H\u0007\u00a8\u0006\u0007"}, d2={"floor", "Ljava/math/BigDecimal;", "a", "log", "b", "pow", "log10", "anatawa12Libs"})
@JvmName(name="BigDecimalMath")
public final class BigDecimalMath {
    @NotNull
    public static final BigDecimal log10(@NotNull BigDecimal $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        BigDecimal b = $receiver;
        int dp = Integer.MAX_VALUE;
        int NUM_OF_DIGITS = dp + 2;
        MathContext mc = new MathContext(NUM_OF_DIGITS, RoundingMode.HALF_EVEN);
        if (b.signum() <= 0) {
            throw (Throwable)new ArithmeticException("log of a negative number! (or zero)");
        }
        if (b.compareTo(BigDecimal.ONE) == 0) {
            BigDecimal bigDecimal = BigDecimal.ZERO;
            Intrinsics.checkExpressionValueIsNotNull(bigDecimal, "BigDecimal.ZERO");
            return bigDecimal;
        }
        if (b.compareTo(BigDecimal.ONE) < 0) {
            BigDecimal bigDecimal = BigDecimal.ONE.divide(b, mc);
            Intrinsics.checkExpressionValueIsNotNull(bigDecimal, "(BigDecimal.ONE.divide(b, mc))");
            BigDecimal bigDecimal2 = BigDecimalMath.log10(bigDecimal).negate();
            Intrinsics.checkExpressionValueIsNotNull(bigDecimal2, "(BigDecimal.ONE.divide(b, mc)).log10().negate()");
            return bigDecimal2;
        }
        StringBuffer sb = new StringBuffer();
        int leftDigits = b.precision() - b.scale();
        sb.append(leftDigits - 1).append(".");
        for (int n = 0; n < NUM_OF_DIGITS; ++n) {
            Intrinsics.checkExpressionValueIsNotNull(b.movePointLeft(leftDigits - 1).pow(10, mc), "b.movePointLeft(leftDigits - 1).pow(10, mc)");
            leftDigits = b.precision() - b.scale();
            sb.append(leftDigits - 1);
        }
        BigDecimal ans = new BigDecimal(sb.toString());
        BigDecimal bigDecimal = ans.round(new MathContext(ans.precision() - ans.scale() + dp, RoundingMode.HALF_EVEN));
        Intrinsics.checkExpressionValueIsNotNull(bigDecimal, "ans.round(MathContext(an\u2026 RoundingMode.HALF_EVEN))");
        ans = bigDecimal;
        return ans;
    }

    @NotNull
    public static final BigDecimal log(@NotNull BigDecimal a, @NotNull BigDecimal b) {
        Intrinsics.checkParameterIsNotNull(a, "a");
        Intrinsics.checkParameterIsNotNull(b, "b");
        BigDecimal bigDecimal = BigDecimalMath.log10(a);
        BigDecimal bigDecimal2 = BigDecimalMath.log10(b);
        BigDecimal bigDecimal3 = bigDecimal.divide(bigDecimal2, RoundingMode.HALF_EVEN);
        Intrinsics.checkExpressionValueIsNotNull(bigDecimal3, "this.divide(other, RoundingMode.HALF_EVEN)");
        return bigDecimal3;
    }

    @NotNull
    public static final BigDecimal pow(@NotNull BigDecimal a, @NotNull BigDecimal b) {
        Intrinsics.checkParameterIsNotNull(a, "a");
        Intrinsics.checkParameterIsNotNull(b, "b");
        BigDecimal bigDecimal = BigDecimal.ONE;
        Intrinsics.checkExpressionValueIsNotNull(bigDecimal, "BigDecimal.ONE");
        BigDecimal bigDecimal2 = bigDecimal;
        BigDecimal bigDecimal3 = BigDecimalMath.log10(a);
        BigDecimal bigDecimal4 = bigDecimal3.multiply(b);
        Intrinsics.checkExpressionValueIsNotNull(bigDecimal4, "this.multiply(other)");
        bigDecimal3 = BigDecimalMath.log10(bigDecimal4);
        BigDecimal bigDecimal5 = bigDecimal2.divide(bigDecimal3, RoundingMode.HALF_EVEN);
        Intrinsics.checkExpressionValueIsNotNull(bigDecimal5, "this.divide(other, RoundingMode.HALF_EVEN)");
        return bigDecimal5;
    }

    @NotNull
    public static final BigDecimal floor(@NotNull BigDecimal a) {
        Intrinsics.checkParameterIsNotNull(a, "a");
        BigDecimal bigDecimal = a.setScale(0, 1);
        Intrinsics.checkExpressionValueIsNotNull(bigDecimal, "a.setScale(0, BigDecimal.ROUND_DOWN)");
        return bigDecimal;
    }
}

